/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateFastAttackAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.PainfulStabsPower;

public class BookOfStabbing
extends AbstractMonster {
    public static final String ID = "BookOfStabbing";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("BookOfStabbing");
    public static final String NAME = BookOfStabbing.monsterStrings.NAME;
    public static final String[] MOVES = BookOfStabbing.monsterStrings.MOVES;
    public static final String[] DIALOG = BookOfStabbing.monsterStrings.DIALOG;
    private static final int HP_MAX = 164;
    private static final int STAB_DAMAGE = 6;
    private static final int BIG_STAB_DAMAGE = 21;
    private static final byte STAB = 1;
    private static final byte BIG_STAB = 2;
    private int stabCount = 1;

    public BookOfStabbing() {
        super(NAME, ID, 164, 0.0f, -30.0f, 320.0f, 410.0f, null, 0.0f, 15.0f);
        this.loadAnimation("images/monsters/theCity/bookOfStabbing/skeleton.atlas", "images/monsters/theCity/bookOfStabbing/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "finger_wiggle", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        this.type = AbstractMonster.EnemyType.ELITE;
        this.dialogX = -70.0f * Settings.scale;
        this.dialogY = 50.0f * Settings.scale;
        this.damage.add(new DamageInfo(this, 6));
        this.damage.add(new DamageInfo(this, 21));
    }

    @Override
    public void usePreBattleAction() {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new PainfulStabsPower(this)));
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                AbstractDungeon.actionManager.addToBottom(new AnimateFastAttackAction(this));
                for (int i = 0; i < this.stabCount; ++i) {
                    AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_VERTICAL));
                }
                break;
            }
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.SLASH_VERTICAL));
                break;
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    @Override
    protected void getMove(int num) {
        if (num < 15) {
            if (this.lastMove((byte)2)) {
                ++this.stabCount;
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 6, this.stabCount, true);
            } else {
                this.setMove((byte)2, AbstractMonster.Intent.ATTACK, 21);
            }
        } else if (this.lastTwoMoves((byte)1)) {
            this.setMove((byte)2, AbstractMonster.Intent.ATTACK, 21);
        } else {
            ++this.stabCount;
            this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 6, this.stabCount, true);
        }
    }

    @Override
    public void die() {
        super.die();
        CardCrawlGame.sound.play("STAB_BOOK_DEATH");
    }
}

